
module.exports = [{

    languageOptions: {
        ecmaVersion: 12,
        sourceType: "script",
        globals: {
        },
    },

    rules: {
        // "brace-style": ["warn", "1tbs"],
        "consistent-return": "error",
        "keyword-spacing": "error",
        "no-alert": "error",
        "no-array-constructor": "error",
        "no-caller": "error",
        "no-catch-shadow": "error",
        "no-const-assign": "error",
        "no-constant-condition": "warn",
        "no-dupe-args": "error",
        "no-dupe-class-members": "error",
        "no-dupe-else-if": "error",
        "no-dupe-keys": "error",
        "no-duplicate-case": "error",
        "no-else-return": "off",
        "no-empty": "warn",
        "no-empty-function": "error",
        "no-eval": "error",
        "no-ex-assign": "error",
        "no-fallthrough": "error",
        "no-implied-eval": "error",
        "no-inner-declarations": "error",
        "no-iterator": "error",
        "no-lonely-if": "error",
        "no-multi-spaces": "error",
        "no-multi-str": "error",
        "no-native-reassign": "error",
        "no-nested-ternary": "error",
        "no-new": "error",
        "no-new-func": "error",
        "no-new-object": "error",
        "no-new-wrappers": "error",
        "no-obj-calls": "error",
        "no-octal-escape": "error",
        "no-proto": "error",
        "no-redeclare": "error",
        "no-regex-spaces": "error",
        "no-script-url": "error",
        "no-self-assign": ["error", { props: true }],
        "no-self-compare": "error",
        "no-sequences": "error",
        "no-throw-literal": "error",
        "no-trailing-spaces": "error",
        "no-unreachable": "error",
        "no-unsafe-finally": "error",
        "no-unsafe-negation": "error",
        "no-unused-expressions": "error",
        "no-unused-vars": ["warn", { vars: "local", args: "after-used" }], // Ignore unused global variables
        // "no-use-before-define": ["error", { functions: true, classes: true, variables: true }],
        "no-useless-call": "off",
        "no-useless-catch": "error",
        "no-useless-computed-key": "error",
        "no-useless-concat": "error",
        "no-useless-escape": "error",
        "no-useless-return": "error",
        "no-var": "error",
        "no-void": "error",
        // "object-curly-spacing": [ "error"],
        "prefer-const": "error",
        semi: "error",

        "semi-spacing": ["error", {
            after: true,
            before: false,
        }],

        "space-before-blocks": "error",
        "space-before-function-paren": "off",
        "space-infix-ops": "error",
        "switch-colon-spacing": "error",
        "use-isnan": "error",
    },
}];